;/* $Header: /lsid/semaphore/clarinet/custom/dspset_.h 1.6 1997/03/21 00:55:15 donm Exp $ */
;/* (C) Copyright 1996, Hewlett-Packard Company, all rights reserved. */
;/* */
;/* This is the unix version of the dos file. */
;/* Use "ux2dos' and "dos2ux" to convert. */

;/*######################################################################### */
;/*#### WARNING: THIS FILE IS USED BY CUSTOM SIGNAL MODES (srcusr.asm) ##### */
;/*######################################################################### */

;/* ####################################################################### */
;/*	DSP56002 Register values */
;/* ####################################################################### */

;/* */
;/* Phase Locked Loop control setting, PCTL (X:$FFFD) */
;/* */
 define	FPCTL_NORM_1	'$070003' ;/* CKOUT on, VCO = 40 MHz, clk = 40 MHz */
 define	FPCTL_PROG_1	'$071003' ;/* CKOUT on, VCO = 40 MHz, clk = 20 MHz */
 define	FPCTL_BOOT_1	'$070003' ;/* CKOUT on, VCO = 40 MHz, clk = 40 MHz */
 define	FPCTL_NORM_2	'$070007' ;/* CKOUT on, VCO = 80 MHz, clk = 80 MHz */
 define	FPCTL_PROG_2	'$072007' ;/* CKOUT on, VCO = 80 MHz, clk = 20 MHz */
 define	FPCTL_BOOT_2	'$070007' ;/* CKOUT on, VCO = 80 MHz, clk = 80 MHz */
;/* the 2 channel source uses CKOUT to strobe peripheral registers */

;/*	define	FPCTL_INIT	'$1F0003' ;/* CKOUT off, 40 Mhz */
;/* */ 
;/* FPCTL0:11 (MF) = $003 ;/*multiplication number = MF+1 = 3+1 =4 */
;/* FPCTL12:15 (DF) = $0;/*low power divider division number = (2)^(DF) = 1 */
;/* FPCTL16 (XTLD) = $1 ;/*a 1 turnsoff XTALoutputpin,reducing RFI and power */
;/* FPCTL17 (PSTP) = $1	;/*a 1 allows fastest start up after stop, PLL on */
;/* FPCTL18 (PEN) = $1	;/*a 1 here enables the PLL and is redundant with */
			;/*the PINIT pin being high at power up */
;/* FPCTL19:20 (COD) = $0	;/*the CKOUT pin is enabled for xilinx */
;/* FPCTL21 (CSRC) = $0	;/*the chip clock is taken from the low power divider*/
			;/*this is the rest value*/
;/* FPCTL22 (CKOS) = $0 ;/*CKOUT pin is from the LP divider, the reset values*/
;/* FPCTL23 = $0	;/*this bit is reserved and should be set to 0*/

;/* */
;/* wait state values, bus control register, BCR (X:$FFFE) page 9-13 */

;/* 1 channel (daughter board) wait states */
	;/* 40 MHz clock, normal clock but cannot write to FLASHROM */
        ;/* changed Peri wait states from 2 to for for prngen */

 	define	FBCR_NORM_1 '$1114'  ;/* Xmem,Ymem,Pmem,Peri for 40MHz 56002 */
	define	FBCR_ROM_1  '$1154' ;/* Xmem,Ymem,Pmem,Peri for 40MHz, slow ROMREAD */
	define	FBCR_ADC_1  '$1116'  ;/* Xmem,Ymem,Pmem,Peri for 40MHz, slow for ADC */
	define	FBCR_SLO_1  '$1156'  ;/* Xmem,Ymem,Pmem,Peri for 40MHz, slow for ADC, ROMREAD */

	;/* 20 MHz clock, used for writing to FLASHROM programming */
	define FBCR_PROG_1 '$0022'  ;/* X,Y,P,Y:Peri for 20MHz, slow for ROM W/R, ADC */

;	define	FBCR_40	'$1114'  ;/* Xmem,Ymem,Pmem,Peri for 40MHz 56002 */
;	define	FBCR_40ROM  '$1154' ;/* Xmem,Ymem,Pmem,Peri slow for ROMREAD */
;	define	FBCR_40ADC  '$1116'  ;/* Xmem,Ymem,Pmem,Peri slow for ADC */
;	define	FBCR_40SLO  '$1156'  ;/* Xmem,Ymem,Pmem,Peri slow for ADC */

	;/* 20 MHz clock, used for writing to FLASHROM programming */
;	define	FBCR_20	 '$0022'  ;/* X,Y,P,Y:Peri slow for ROM W/R, ADC */

	;/* 10 MHz clock, turn on clock (at reset 15ws), change ws to 0 */
;	define	FBCR_10	 '$0011'  ;/* X,Y,P,Y:Peri slow for ROM W/R, ADC */

;/* 2 channel (SCA) wait states */
;/* the 2 channel source uses CKOUT to strobe peripheral registers */
	;/* 80 MHz clock, normal clock but cannot write to FLASHROM */
;	80 MHz Clock:

;	  SRAM: 1 WS
;	  Flash EPROM Read: 10 WS
;	  All other peripherals: 12 WS
;
;	20 MHz Clock:
;	  Flash EPROM Write: 1 WS

 	define	FBCR_NORM_2 '$222c'  ;/* Xmem,Ymem,Pmem,Peri for 80MHz 56002 */
	define	FBCR_ROM_2  '$22ac' ;/* Xmem,Ymem,Pmem,Peri for 80MHz, slow ROMREAD */
	define	FBCR_ADC_2  '$222c'  ;/* Xmem,Ymem,Pmem,Peri for 80MHz, slow for ADC */
	define	FBCR_SLO_2  '$22ac'  ;/* Xmem,Ymem,Pmem,Peri for 80MHz, slow for ADC, ROMREAD */

	;/* 20 MHz clock, used for writing to FLASHROM programming */
        ; need to leave peri waitstates to c for write pulse generation state machine
	define FBCR_PROG_2 '$002c'  ;/* X,Y,P,Y:Peri for 20MHz, slow for ROM W/R, ADC */


;/* */
;/*	settings for Host Port, PBC (X:$FFE0), HCR (X:$FFE8) */
;/* */
	define	FPBC_INIT  '$1'	;/* Host port, HACKn not GPIO */
	define	FHCR_INIT  '$0'	;/* Not Host Port interrupts, no flags set */
	define	FHCR_RC	  '$5'	;/* no flags set, interrupt on REC and CMD */
	define	FHCR_RCT  '$7'	;/* no flags, interrupt on REC, CMD XMIT */
	define	FHCR_RCT2  '$F'	;/* HF2 set, interrupt on REC, CMD XMIT */

;/* */
;/*	settings for Port C */
;/* */
;/*  PCC (X:$FFE1), Port C Control Register */
;/* */
	define  FPCC_SSI_INIT	'$000168'
        define  FPCC_SSI_RESET       '$000000'
	;/*  FPCC0 (RXD) = 0 (C Port) */
	;/*  FPCC1 (TXD) = 0 (C Port) TESTBIT bit */
	;/*  FPCC2 (SCLK) = 0 (C Port) */
	;/*  FPCC3 (SC0) = 1 (SSI) TRGOn out */
	;/*  FPCC4 (SC1) = 0 (C Port) */
	;/*  FPCC5 (SC2) = 1 (SSI) FRMSYNC in */
	;/*  FPCC6 (SCK) = 1 (SSI) serial clock in */
	;/*  FPCC7 (SRD) = 0 (C Port) FLASHEN */
	;/*  FPCC8 (STD) = 1 (SSI) serial data out */
;/* */
;/*Set C Port Data (X:$FFFE5)to FPCD_INIT before assigning directions at INIT*/
;/* */
	define  FPCD_INIT	'$00'	;/* no TESTBIT, no FLASHEN */
	define  FPCD_TESTBIT	'$02'	;/* test bit TP3 */
	define  FPCD_FLASHENBIT	'$40'	;/* flash ROM program enable */
;/* */
;/*  PCDIR (X:$FFE3), C Port Data Direction Register */
;/* */
	define	FPCDDR_INIT  '$000082' ;/* set PC1,7 as outputs */
	;/*  FPCDIR0 (RXD) = 0 (C Port, not used) */
	;/*  FPCDIR1 (TXD) = 1 (C Port, output) TESTBIT */
	;/*  FPCDIR2 (SCLK) = 0 (C Port, not used) */
	;/*  FPCDIR3 (SC0) = 0 (SSI) */
	;/*  FPCDIR4 (SC1) = 0 (C Port, not used) SPARE3 */
	;/*  FPCDIR5 (SC2) = 0 (SSI) */
	;/*  FPCDIR6 (SCK) = 0 (SSI) */
	;/*  FPCDIR7 (SRD) = 1 (C Port, output) FLASHEN */
	;/*  FPCDIR8 (STD) = 0 (SSI) */

;/* */
;/*  SSI - CRA (X:$FFEC) */
;/* */
	define FCRA_INIT	    	'$006100'
	;/*  PM0:7 (internal divider, not used) */
	;/*  DC0:4 = 2 words per frame in network mode (2 channel), or word */
	;/*          rate divisor in normal (1 channel) mode. */
	;/*  WL1:0 = 3  (24 bit word length) */
	;/*  PSR (internal divider, not used) */

;/* */
;/*  SSI - CRB (X:$FFED) */
;/* */
	define FCRB_INIT1    	'$000205' ;/*no xmit, no xmit intr, no trig */
	define FCRB_XMIT1    	'$005205' ;/*xmit, xmit intr, no trg */
	define FCRB_XMIT1_NOINTR    '$001205' ;/*xmit, no xmit intr, no trg */
	define FCRB_XMIT1_TRG   	'$005204' ;/*xmit, xmit intr, trg */
	define FCRB_INIT2  '$000A05' ;/*2CH, no xmit, no xmit intr, no trig */
	define FCRB_XMIT2    	'$005A05' ;/*2CH, xmit, xmit intr, no trg */
	define FCRB_XMIT2_NOINTR '$001A05' ;/*2CH, xmit, no xmit intr, no trg */
	define FCRB_XMIT2_TRG 	'$005A04' ;/*2CH, xmit, xmit intr, trg */
	;/*  OF0 = 1, used for no embedded trigger flag, SCATRGOn */
		;/*  OF0 = 01, used for embedded trigger flag, SCATRGOn */
	;/*  OF1 = 0,  not used */
	;/*  SCD0 = 1, used for embedded trigger out */
	;/*  SCD1 = 0, not used */

	;/*  SCD2 = 0, transmit frame sync in */
	;/*  SCKD = 0, input transmit bit clock */
	;/*  SHFD = 0, shift direction MSB first */
	;/*  FSL0 = 0, Rx amd Tx same length frame sync */

	;/*  FSL1 = 0, word length frame sync */
	;/*  SYN = 1, synchronous */
	;/*  GCK = 0, continuous clock */
	;/*  MOD = 0, normal mode (single channel) 1 data word / frame */
	     ;/*  MOD = 1, network mode (dual channel) 2 data words /frame */

	;/*  TE = 0,  dont transmit data with next frame sync */
	     ;/*  TE = 1,  do transmit data with next frame sync */
	;/*  RE = 0,  not used */
	;/*  TIE = 0, disable transmit interrupt */
		;/*  TIE = 1, enable transmit interrupt */
	;/*  RIE = 0, not used */

;/* */
;/* Interrupt enables and priority levels pg 8-17, IPR (X:$FFFF) */
;/*  E = Negative Edge triggered */
;/*  L = low level triggered */
;/*					    SCI SSI HOST IRQB IRQA */
	define	FIPR_BOOT	'$0000'	;/* OFF OFF OFF  OFF  OFF  */
;	define	FIPR_MON 	'$0C16'	;/* OFF OFF  2   L1   E1   */
	define	FIPR_MON 	'$0C00'	;/* OFF OFF  2   OFF  OFF  */
	define	FIPR_MONHP	'$0C00'	;/* OFF OFF  2   OFF  OFF  */
;	define	FIPR_MEAS	'$2C16'	;/* OFF  1   2   L1   E1   */
;	define	FIPR_MEAS	'$2C10'	;/* OFF  1   2   L1   OFF  */
;	define	FIPR_MEAS	'$2C00'	;/* OFF  1   2   OFF  OFF  */
	define	FIPR_MEAS	'$2C07'	;/* OFF  1   2   OFF  E2   */
	define	FIPR_MEASFR	'$2C07'	;/* OFF  1   2   OFF  E2   */
	define	FIPR_SSI	'$2000'	;/* OFF  1  OFF  OFF  OFF  */
	define	FIPR_SSIHP	'$2C00'	;/* OFF  1   2   OFF  OFF  */

;/* */
;/* Interrupt priority level masks for MR in the SR (Status Reg) */
;/*   To avoid an inadvertent drop in IPL, do the following: */
;/*     1.  set IPL to 3 by:		ori     #FMR_IPL3_OR,mr */
;/*     2.  set IPL to desired level by:  andi    #FMR_IPL1,mr */
;/*   See "andi" and "ori" descriptions for RTI and do loop restrictions */
;/* */
	define	FMR_IPL3_OR	'$03'
	define	FMR_IPL0	'$FC'
	define	FMR_IPL1	'$FD'
	define	FMR_IPL2	'$FE'
	define	FMR_IPL3	'$FF'

;/* */
;/* Scaling mode control */
;/*   do "andi" to clear then "ori" to set */
;/* */
	define	FMR_SCLCLR	'$FF'	;/* usage: andi    #FMR_SCLCLR,mr */
	define	FMR_SCLDN	'$04'	;/* usage: ori     #FMR_SCLDN,mr */
	define	FMR_SCLUP	'$08'	;/* usage: ori     #FMR_SCLUP,mr */

;/* */
;/* Trace bit control */
;/* */
	define	FMR_TRCCLR	'$DF'	;/* usage: andi    #FSR_TRCCLR,mr */
	define	FMR_TRCSET	'$20'	;/* usage: ori     #FSR_TRCSET,mr */

;/* */
;/* On Chip Data ROM control, OMR */
;/* */
	define	FOMR_OCROMOFF	'$FB'	;/* usage: andi   #FOMR_OCROMOFF,omr */
	define	FOMR_OCROMON	'$04'	;/* usage: ori     #FOMR_OCROMON,omr */
	define	FOMR_ROMBOOT	'$000001'  ;/* usage: move #FOMR_ROMBOOT,omr */
